
#include "HX711.h"

#define calibration_factor -1740.0 //This value is obtained using the Calibration sketch

#define DOUT  26
#define CLK  25

HX711 scale;

void setup() {
  Serial.begin(9600);
  Serial.println("HX711 scale demo");

  scale.begin(DOUT, CLK);
  scale.set_scale(calibration_factor); //This value is obtained by using the Calibration sketch
  scale.tare(); //Assuming there is no weight on the scale at start up, reset the scale to 0

  Serial.println("Readings:");
}

void loop() {
  float mass = scale.get_units() / 1000;
  float force = mass *  9.8;
  Serial.print("Reading: ");
  Serial.print(mass); //scale.get_units() returns a float
  Serial.print(" g, "); //You can change this to kg but you'll need to refactor the calibration_factor
  Serial.print(force); //scale.get_units() returns a float
  Serial.print(" N.");
  Serial.println();
}
